// Persistence of Vision Ray Tracer Include File
// File: parameters.inc
// Vers: 3.6
// Desc: Include file for the Beads'N'Wires project
// Date: Sept-Oct 2004
// Auth: Maurice Hendrix


// bead size=25mm
#declare bead_size = 2.5/2;

// bead inside=10mm
#declare bead_bore = 1.0/2;
// unit of scale = 10mm = 1cm


// wire diameter=5mm
#declare wire_d = 0.6;
#declare wire_r = wire_d/2;

#declare gauge = bead_bore - wire_r;

#declare plank_width = 20;
#declare plank_depth = 30;
#declare plank_height = 2;

#declare mount_thickness =0.2;

#declare ribbe=2;
#declare kubus_dev=(2*bead_size-ribbe)/2;

//material removed at each end of the 'bal'
#declare bal_cap=0.2;

//material removed at each end of the 'ovaal'
#declare ovaal_cap=0.6;
// ovaal_scale makes sure that the height of the bead is the same as a bal
#declare ovaal_scale= ((2*bead_size) - (2*bal_cap))/((2*bead_size)-(2*ovaal_cap));